//
//  Marble.h
//  Marble
//
//  Created by Jonathan Diehl on 29.11.10.
//  Copyright 2010 RWTH. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <QuartzCore/QuartzCore.h>

#define MARBLE_FRICTION 0.2
#define MARBLE_ACCELERATION_FACTOR 5.0


@interface Marble : NSObject {
	CALayer *layer;
	
	CGPoint speed;
	
	CGFloat friction;
	CGFloat accelerationFactor;
	CGFloat bounce;
	CGFloat size;
	CGRect bounds;
}

// configuration parameters
@property(assign) CGFloat friction;
@property(assign) CGFloat accelerationFactor;
@property(assign) CGFloat bounce;
@property(assign) CGFloat size;
@property(assign) CGRect bounds;

// state properties
@property(assign) CGPoint position;
@property(assign) CGPoint speed;

// init
- (id)initWithView:(UIView *)view;

// control methods
- (void)accelerate:(CGPoint)acceleration;
- (void)stop;

// timer update
- (void)update;

@end
